from argparse import ArgumentParser
import functools

def cmdline_args():
    pargs = ArgumentParser(description="HARL")
    pargs.add_argument("-a","--abstraction",
                    default="centroid",
                    help="centroid to use state hops, interface to use interface hops")
    pargs.add_argument("-c", "--config",
                        default='parameters.yaml',
                        help='Parameters YAML file')
    pargs.add_argument("-m", "--mode",
                       default = "train",
                       help="Train to run the policy training/mode to simulate stored policies")
    pargs.add_argument("-r", "--runid",
                        default='1',
                        help='Run ID for the experiment logs')
    pargs.add_argument("-s", "--seed",
                        default=1337,
                        type=functools.partial(int, base=0),
                        help='Experiment seed')

    return pargs.parse_args()